<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class MigrationToken extends \Google\Model
{
  /**
   * This value must not be used.
   */
  public const MANAGEMENT_MODE_MANAGEMENT_MODE_UNSPECIFIED = 'MANAGEMENT_MODE_UNSPECIFIED';
  /**
   * A work profile on a personally owned device. Supported only on devices
   * running Android 9 and above.
   */
  public const MANAGEMENT_MODE_WORK_PROFILE_PERSONALLY_OWNED = 'WORK_PROFILE_PERSONALLY_OWNED';
  /**
   * A work profile on a company-owned device. Supported only on devices running
   * Android 11 and above.
   */
  public const MANAGEMENT_MODE_WORK_PROFILE_COMPANY_OWNED = 'WORK_PROFILE_COMPANY_OWNED';
  /**
   * A fully-managed device. Supported only on devices running Android 9 and
   * above.
   */
  public const MANAGEMENT_MODE_FULLY_MANAGED = 'FULLY_MANAGED';
  /**
   * Immutable. Optional EMM-specified additional data. Once the device is
   * migrated this will be populated in the migrationAdditionalData field of the
   * Device resource. This must be at most 1024 characters.
   *
   * @var string
   */
  public $additionalData;
  /**
   * Output only. Time when this migration token was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. Once this migration token is used to migrate a device, the
   * name of the resulting Device resource will be populated here, in the form
   * enterprises/{enterprise}/devices/{device}.
   *
   * @var string
   */
  public $device;
  /**
   * Required. Immutable. The id of the device, as in the Play EMM API. This
   * corresponds to the deviceId parameter in Play EMM API's Devices.get
   * (https://developers.google.com/android/work/play/emm-
   * api/v1/devices/get#parameters) call.
   *
   * @var string
   */
  public $deviceId;
  /**
   * Immutable. The time when this migration token expires. This can be at most
   * seven days from the time of creation. The migration token is deleted seven
   * days after it expires.
   *
   * @var string
   */
  public $expireTime;
  /**
   * Required. Immutable. The management mode of the device or profile being
   * migrated.
   *
   * @var string
   */
  public $managementMode;
  /**
   * Output only. The name of the migration token, which is generated by the
   * server during creation, in the form
   * enterprises/{enterprise}/migrationTokens/{migration_token}.
   *
   * @var string
   */
  public $name;
  /**
   * Required. Immutable. The name of the policy initially applied to the
   * enrolled device, in the form enterprises/{enterprise}/policies/{policy}.
   *
   * @var string
   */
  public $policy;
  /**
   * Input only. The time that this migration token is valid for. This is input-
   * only, and for returning a migration token the server will populate the
   * expireTime field. This can be at most seven days. The default is seven
   * days.
   *
   * @var string
   */
  public $ttl;
  /**
   * Required. Immutable. The user id of the Managed Google Play account on the
   * device, as in the Play EMM API. This corresponds to the userId parameter in
   * Play EMM API's Devices.get
   * (https://developers.google.com/android/work/play/emm-
   * api/v1/devices/get#parameters) call.
   *
   * @var string
   */
  public $userId;
  /**
   * Output only. The value of the migration token.
   *
   * @var string
   */
  public $value;

  /**
   * Immutable. Optional EMM-specified additional data. Once the device is
   * migrated this will be populated in the migrationAdditionalData field of the
   * Device resource. This must be at most 1024 characters.
   *
   * @param string $additionalData
   */
  public function setAdditionalData($additionalData)
  {
    $this->additionalData = $additionalData;
  }
  /**
   * @return string
   */
  public function getAdditionalData()
  {
    return $this->additionalData;
  }
  /**
   * Output only. Time when this migration token was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. Once this migration token is used to migrate a device, the
   * name of the resulting Device resource will be populated here, in the form
   * enterprises/{enterprise}/devices/{device}.
   *
   * @param string $device
   */
  public function setDevice($device)
  {
    $this->device = $device;
  }
  /**
   * @return string
   */
  public function getDevice()
  {
    return $this->device;
  }
  /**
   * Required. Immutable. The id of the device, as in the Play EMM API. This
   * corresponds to the deviceId parameter in Play EMM API's Devices.get
   * (https://developers.google.com/android/work/play/emm-
   * api/v1/devices/get#parameters) call.
   *
   * @param string $deviceId
   */
  public function setDeviceId($deviceId)
  {
    $this->deviceId = $deviceId;
  }
  /**
   * @return string
   */
  public function getDeviceId()
  {
    return $this->deviceId;
  }
  /**
   * Immutable. The time when this migration token expires. This can be at most
   * seven days from the time of creation. The migration token is deleted seven
   * days after it expires.
   *
   * @param string $expireTime
   */
  public function setExpireTime($expireTime)
  {
    $this->expireTime = $expireTime;
  }
  /**
   * @return string
   */
  public function getExpireTime()
  {
    return $this->expireTime;
  }
  /**
   * Required. Immutable. The management mode of the device or profile being
   * migrated.
   *
   * Accepted values: MANAGEMENT_MODE_UNSPECIFIED,
   * WORK_PROFILE_PERSONALLY_OWNED, WORK_PROFILE_COMPANY_OWNED, FULLY_MANAGED
   *
   * @param self::MANAGEMENT_MODE_* $managementMode
   */
  public function setManagementMode($managementMode)
  {
    $this->managementMode = $managementMode;
  }
  /**
   * @return self::MANAGEMENT_MODE_*
   */
  public function getManagementMode()
  {
    return $this->managementMode;
  }
  /**
   * Output only. The name of the migration token, which is generated by the
   * server during creation, in the form
   * enterprises/{enterprise}/migrationTokens/{migration_token}.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Required. Immutable. The name of the policy initially applied to the
   * enrolled device, in the form enterprises/{enterprise}/policies/{policy}.
   *
   * @param string $policy
   */
  public function setPolicy($policy)
  {
    $this->policy = $policy;
  }
  /**
   * @return string
   */
  public function getPolicy()
  {
    return $this->policy;
  }
  /**
   * Input only. The time that this migration token is valid for. This is input-
   * only, and for returning a migration token the server will populate the
   * expireTime field. This can be at most seven days. The default is seven
   * days.
   *
   * @param string $ttl
   */
  public function setTtl($ttl)
  {
    $this->ttl = $ttl;
  }
  /**
   * @return string
   */
  public function getTtl()
  {
    return $this->ttl;
  }
  /**
   * Required. Immutable. The user id of the Managed Google Play account on the
   * device, as in the Play EMM API. This corresponds to the userId parameter in
   * Play EMM API's Devices.get
   * (https://developers.google.com/android/work/play/emm-
   * api/v1/devices/get#parameters) call.
   *
   * @param string $userId
   */
  public function setUserId($userId)
  {
    $this->userId = $userId;
  }
  /**
   * @return string
   */
  public function getUserId()
  {
    return $this->userId;
  }
  /**
   * Output only. The value of the migration token.
   *
   * @param string $value
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MigrationToken::class, 'Google_Service_AndroidManagement_MigrationToken');
