<?php
require_once 'connect.php';


try {
    $conn = getDatabaseConnection();
    $query = "SELECT id, name FROM categories";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    $categories = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $categories[] = [
            'id' => (int)$row['id'],
            'name' => $row['name']
        ];
    }
    
    http_response_code(200);
    echo json_encode($categories);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Failed to fetch categories",
        "error" => $e->getMessage()
    ]);
}
?>