<?php
require_once 'connect.php';
try {
    $conn = getDatabaseConnection();

  
    $id = $_POST['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Blog ID is required',
        ]);
        exit();
    }

  
    $conn->beginTransaction();

    // Handle file upload if new image provided
    $cover_image_path = null;
    if (!empty($_FILES['cover_image']['name'])) {
        $target_dir = 'uploads/';
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0755, true);
        }
        $target_file = $target_dir . basename($_FILES['cover_image']['name']);

        if (
            move_uploaded_file($_FILES['cover_image']['tmp_name'], $target_file)
        ) {
            $cover_image_path = $target_file;
        }
    }

    $query =
        "UPDATE blogs SET 
              title = :title,
              category = :category_id,
              blog_type = :blog_type,
              content = :content,
              status = :status" .
        ($cover_image_path ? ', cover_image_path = :cover_image_path' : '') .
        ' WHERE id = :id';

    $stmt = $conn->prepare($query);

    $stmt->bindParam(':title', $_POST['title']);
    $stmt->bindParam(':category_id', $_POST['category_id'], PDO::PARAM_INT);
    $stmt->bindParam(':blog_type', $_POST['blog_type']);
    $stmt->bindParam(':content', $_POST['content']);
    $stmt->bindParam(':status', $_POST['status']);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    if ($cover_image_path) {
        $stmt->bindParam(':cover_image_path', $cover_image_path);
    }

    $stmt->execute();

    if (isset($_POST['tags'])) {
        $deleteStmt = $conn->prepare(
            'DELETE FROM blog_tags WHERE blog_id = :blog_id'
        );
        $deleteStmt->bindParam(':blog_id', $id, PDO::PARAM_INT);
        $deleteStmt->execute();

        $tags = json_decode($_POST['tags'], true);
        if (is_array($tags) && count($tags) > 0) {
            $insertQuery = 'INSERT INTO blog_tags (blog_id, tag_id) VALUES ';
            $insertParams = [];
            $values = [];

            foreach ($tags as $index => $tag_id) {
                $values[] = '(:blog_id, :tag_id_' . $index . ')';
                $insertParams[':tag_id_' . $index] = (int) $tag_id;
            }

            $insertQuery .= implode(', ', $values);
            $insertStmt = $conn->prepare($insertQuery);
            $insertStmt->bindValue(':blog_id', $id, PDO::PARAM_INT);

            foreach ($insertParams as $key => $value) {
                $insertStmt->bindValue($key, $value, PDO::PARAM_INT);
            }

            $insertStmt->execute();
        }
    }

    $conn->commit();

    echo json_encode([
        'success' => true,
        'message' => 'Blog updated successfully',
        'blog_id' => $id,
    ]);
} catch (PDOException $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
        'error_details' => $e->getTraceAsString(),
    ]);
}
?>
