<?php
require_once 'connect.php';

try {
    $conn = getDatabaseConnection();
    
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['query'])) {
        $term = '%' . $_GET['query'] . '%';
        $limit = isset($_GET['mode']) && $_GET['mode'] === 'suggestions' ? 5 : 10;
        
        $stmt = $conn->prepare("
            SELECT id, title, category, created_at 
            FROM blogs 
            WHERE title LIKE :term
            ORDER BY 
                CASE 
                    WHEN title LIKE :start_term THEN 0 
                    ELSE 1 
                END,
                created_at DESC
            LIMIT :limit
        ");
        
        $start_term = $_GET['query'] . '%'; 
        $stmt->bindParam(':term', $term);
        $stmt->bindParam(':start_term', $start_term);
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode([
            "success" => true,
            "data" => $results
        ]);
        exit;
    }

    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Missing required parameters"
    ]);

} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Error: " . $e->getMessage()
    ]);
}
?>